// adapted from : http://www.asphonolulu.com/Samples/JS/Tablesort/TableSort.asp

// Ascending Sort of an HTML Table by Column(k)
// Click on Column Heading

// Version 4.0

// Version History

// Version 0.0:  4/11/1999 Only sorted by alpha
// Version 1.0:  4/14/1999 Sorts numeric, but fails if has "$"
// Version 2.0:  4/14/1999 Now handles the "$"
// Version 4.0:  4/16/1999 Now handles the Dates (default is desending)
// [2004Jan12] alei: style indenting, semicolons
// [2004Jan12] alei: added tableElement in aSort to support multiple tables on 1 page
// [2004Jan12] alei: changed image name reference for arrows
// [2004Jan12] alei: accounting for img dividers as a column value and not replacing the innerText with it
// [2004Jan12] alei: using cellIndex to reference the current column instead of passing it in
// [2004Jan14] alei: updated check for img to use innerHTML instead
// [2004Jan14] alei: added check to see either of the 2 values compared are blank, if so, use alpha sort
// [2004Jan14] alei: added check to see if first row is blank, if so, then use alpha sort
//                   it was choking on numeric sort if the first row was blank
//                   an issue still arises when there are blank entries in a numeric-first row column
// [2004Jul03] alei: changed innerText read/writes to innerHTML for supporting form controls
// [2005Apr13] alei: changed row and cell references in aSort to DOM-compliant TR, TD elements for Firefox
//                   compatibility
//                   - assigned currentArrow default value and removed else statement
//                   - changed document.all.item(currentArrow) to use getElementById
//                   - changed the image arrow for loop to target the headingTableElement
//                   - reversed the sort arrow images


// Global variables
var sortCol = 0;
var lastSort = -1;  // column of last sort
var sortDir  = "";  // direction of last sort, "+" = sort ascending, "-" = sort descending

function CompareD(a, b) {  // Date
    d1 = new Date(a[sortCol]);
    d2 = new Date(b[sortCol]);
    if(d1 < d2) { return -1; }
    if(d1 > d2) { return 1; }
    return 0;
}

function CompareA(a, b) {  // Alpha
    if(a[sortCol] < b[sortCol]) { return -1; }
    if(a[sortCol] > b[sortCol]) { return 1; }
    return 0;
}

function CompareN(a, b) {  // Numeric
    // Note: Next version try to remove a leading "$" from the number before "a-b"
    // Remove "$"
    n1 = a[sortCol];
    if(n1.indexOf("$") >= 0){ n1 = n1.substr(1); }
    n2 = b[sortCol];
    if(n2.indexOf("$") >= 0){ n2 = n2.substr(1); }
    //alert('a=' + n1 +', b=' + n2 + '\n' + 'a=' + isNaN(n1) +', b=' + isNaN(n2));
    if( isNaN(n1) || isNaN(n2) ) {
        return CompareA(n1, n2);
    } else {
        return n1-n2;
    }

    //return a[sortCol]-b[sortCol];
}

function aSort(itemName, targetTableName){

    var currentArrow = itemName.id;
    // TD > TR > TBODY > TABLE
    var headingTableElement = itemName.parentNode.parentNode.parentNode;
   //alert(headingTableElement.tagName);
    var dataTableElement = document.getElementById(targetTableName);
    //alert(tableElement)
    var rows = dataTableElement.getElementsByTagName("tr");   
    // look up self reference instead of passing in k
    var column = itemName.cellIndex;
    var k = column;
    var sortCol = k;
    var a = new Array(rows.length)
    for (i=0; i < rows.length; i++) {
        var cells = rows[i].getElementsByTagName("td");  
        a[i] = new Array(cells.length);
        for (j=0; j < cells.length; j++) {
            a[i][j] = cells[j].innerHTML;
        }
    }

    if( k == lastSort ) {
        a.reverse();    // Reverse last sort
    } else {
        if( a[0][k].trim() == "" ) {
            a.sort(CompareA);
        } else {
            if(isNaN(a[0][k])) {    // isNumeric

                if(a[0][k].indexOf("$") >= 0) {
                    a.sort(CompareN);         // Numeric
                    sortDir = "-";
                } else {
                    if(!isNaN(Date.parse(a[0][k]))) {  // isDate
                        a.sort(CompareD);      // compare Date
                        a.reverse();           // make Descending
                        sortDir = "+"
                    } else {
                        a.sort(CompareA)            // Alpha sort
                        sortDir = "-"
                    }
                }
            } else {
                a.sort(CompareN)            // Numeric sort
                sortDir = "-"
            }
            //sortDir = "-"
        }
    }

    if( itemName.id.indexOf("arrow") == -1) {
        currentArrow = "arrow"+itemName.id;// Set the current arrow item.
    }
    var currentArrowImg = document.getElementById(currentArrow);
    if( sortDir == "+" ){
        currentArrowImg.src = "images/icons/sortUpArrow.gif";
        sortDir = "-"
    } else {
        currentArrowImg.src = "images/icons/sortDownArrow.gif";
        sortDir = "+"
    }

    var arrImgTags = headingTableElement.getElementsByTagName("img");
    for (i=0;i< arrImgTags.length;i++) {  // Turn the arrows on and off depending on the sort column.
        if( arrImgTags[i].id.indexOf("arrow") >= 0) {   // Only hide/visible the arrows
            if( arrImgTags[i].id != currentArrow ) {
                arrImgTags[i].style.visibility = "hidden";
            } else {
                arrImgTags[i].style.visibility = "visible";
            }
        }
    }
    for (i=0; i < rows.length; i++) {
        cells = rows[i].getElementsByTagName("td");  
        for (j=0; j < cells.length; j++) {
            // account for image tag dividers
            if( cells[j].innerHTML.toLowerCase().indexOf("<img") == -1 ) {
                cells[j].innerHTML = a[i][j];
            }
        }
    }
    lastSort = k;
}

